Attribute VB_Name = "modDBAccess"
Option Explicit

'Declare public Database variables
Public g_objConn As New ADODB.Connection
Public g_objCmd As New ADODB.Command
Public g_objErrors As ADODB.Errors
Public g_objErr As Error

'Declare private variables
Private m_lngRC As Long
Private m_lngConnectionTimeout As Long
Private m_lngCommandTimeout As Long
Private m_strDSN As String
Private m_strUID As String
Private m_strPWD As String
Private m_strStandardKeyName As String

'Declare private objects
Private m_objReg As clsRegistry

Public Sub CloseDatabase()
   'Close database objects and dereference them
   Set g_objCmd = Nothing
   Set g_objErrors = Nothing
   Set g_objErr = Nothing
   g_objConn.Close
   Set g_objConn = Nothing
End Sub

Public Function OpenDatabase() As Boolean
   'Get the connection settings from the registry
   Call ReadRegistry
   
   'Connect to SQL Server and open the database
   On Error GoTo SQLErr
   With g_objConn
      .ConnectionTimeout = m_lngConnectionTimeout
      .CommandTimeout = m_lngCommandTimeout
      .Open m_strDSN, m_strUID, m_strPWD
   End With
   On Error GoTo 0
   OpenDatabase = True
   Exit Function
SQLErr:
   OpenDatabase = False
End Function

Private Sub ReadRegistry()
   'Get a new instance of the registry class
   Set m_objReg = New clsRegistry
   
   'Set the standard registry key name
   m_strStandardKeyName = "Software\Wrox Press Ltd\Options\"
   
   'Get the connection timeout value
   m_lngRC = m_objReg.QueryKeyValue(m_strStandardKeyName & "Database", _
      "Connection Timeout", HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      'No key was found, set the default
      m_lngConnectionTimeout = 30
      'No key was found, create the key
      m_lngRC = m_objReg.CreateKey(m_strStandardKeyName, "Database", _
         HKEY_LOCAL_MACHINE)
      If m_lngRC <> 0 Then
         App.LogEvent "Error creating registry key", _
            vbLogEventTypeError
      End If
      'No key was found, write the default keys
      Call WriteRegistry
   Else
      m_lngConnectionTimeout = m_objReg.LongKeyValue
   End If
   
   'Get the command timeout value
   m_lngRC = m_objReg.QueryKeyValue(m_strStandardKeyName & "Database", _
      "Command Timeout", HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      'No key was found, set the default
      m_lngCommandTimeout = 30
   Else
      m_lngCommandTimeout = m_objReg.LongKeyValue
   End If

   'Get the dsn string
   m_lngRC = m_objReg.QueryKeyValue(m_strStandardKeyName & "Database", _
      "DSN", HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      'No key was found, set the default
      m_strDSN = "Pubs Connection"
   Else
      m_strDSN = m_objReg.StringKeyValue
   End If

   'Get the userid string
   m_lngRC = m_objReg.QueryKeyValue(m_strStandardKeyName & "Database", _
      "UID", HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      'No key was found, set the default
      m_strUID = "sa"
   Else
      m_strUID = m_objReg.StringKeyValue
   End If

   'Get the password string
   m_lngRC = m_objReg.QueryKeyValue(m_strStandardKeyName & "Database", _
      "PWD", HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      'No key was found, set the default
      m_strPWD = ""
   Else
      m_strPWD = m_objReg.StringKeyValue
   End If
   
   'Dereference the registry object
   Set m_objReg = Nothing
End Sub

Private Sub WriteRegistry()
   'Write the connection timeout value
   m_lngRC = m_objReg.SetKeyValue(m_strStandardKeyName & "Database", _
      "Connection Timeout", 30, REG_DWORD, HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      App.LogEvent "Write Key Failed for Key: Connection Timeout", _
         vbLogEventTypeError
   End If
   
   'Write the command timeout value
   m_lngRC = m_objReg.SetKeyValue(m_strStandardKeyName & "Database", _
      "Command Timeout", 30, REG_DWORD, HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      App.LogEvent "Write Key Failed for Key: Command Timeout", _
         vbLogEventTypeError
   End If

   'Write the dsn string value
   m_lngRC = m_objReg.SetKeyValue(m_strStandardKeyName & "Database", _
      "DSN", "Pubs Connection", REG_SZ, HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      App.LogEvent "Write Key Failed for Key: Connect String", _
         vbLogEventTypeError
   End If

   'Write the user id string value
   m_lngRC = m_objReg.SetKeyValue(m_strStandardKeyName & "Database", _
      "UID", "sa", REG_SZ, HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      App.LogEvent "Write Key Failed for Key: Connect String", _
         vbLogEventTypeError
   End If

   'Write the password string value
   m_lngRC = m_objReg.SetKeyValue(m_strStandardKeyName & "Database", _
      "PWD", "", REG_SZ, HKEY_LOCAL_MACHINE)
   If m_lngRC <> 0 Then
      App.LogEvent "Write Key Failed for Key: Connect String", _
         vbLogEventTypeError
   End If
End Sub


